#ifndef IMETADATAACTIONS_H
#define IMETADATAACTIONS_H

#include <Geometry/IGeometry.h>
#include <buildspec.h>
using namespace GST::Geometry;

namespace GST
{
namespace Parsers
{

/**
	The SemanticActions (interface). This defines the interface of a class to be
   called from a grammar.
*/
class GST_API_EXPORT IMetadataActions
{
public:
	IMetadataActions()
	{
	}
	virtual ~IMetadataActions()
	{
	}

	virtual void SetName(const std::string &name) = 0;
	virtual void SetOriginalName(const std::string &name) = 0;
	virtual void SetColor(const IGeometry::Color &color) = 0;
	virtual void SetTransparency(const IGeometry::TransparencyCode &alpha) = 0;
	virtual void SetCRS(const std::string &crs) = 0;
	virtual void SetCustomProperty(const std::string &name,
								   const std::string &value)
		= 0;
};

} // namespace Parsers
} // namespace GST

#endif // IMetadataActions_H
